@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <form class="modal-content" method="post" action="{{ route('admin.plans.store', $plan->id ?? null) }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Name')</label>
                                    <input type="text" name="name" class="form-control"
                                        value="{{ old('name', $plan->name ?? null) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Maximum Channel Connection')</label>
                                    <input type="number" name="total_channel" class="form-control"
                                        value="{{ old('total_channel', $plan->total_channel ?? null) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Total Post Schedule')</label>
                                    <input type="number" name="total_post_schedule" class="form-control"
                                        value="{{ old('total_post_schedule', $plan->total_post_schedule ?? null) }}"
                                        required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Allow AI Assistant') </label>
                                    <input type="checkbox" data-width="100%" data-height="50" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-on="@lang('Enable')" data-off="@lang('Disable')" name="ai_assistant" @if(isset($plan) && $plan->ai_assistant) checked @endif>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Plan Type')</label>
                                    <select name="plan_type" class="form-control">
                                        <option value="">@lang('Select One')</option>
                                        <option value="{{ Status::MONTHLY }}" @selected(old('plan_type', ($plan->plan_type ?? null)) == Status::MONTHLY)>@lang('MONTHLY')
                                        </option>
                                        <option value="{{ Status::YEARLY }}" @selected(old('plan_type', ($plan->plan_type ?? null)) == Status::YEARLY)>@lang('YEARLY')
                                        </option>
                                        <option value="{{ Status::FREE }}" @selected(old('plan_type', ($plan->plan_type ?? null)) == Status::FREE && old('plan_type', ($plan->plan_type ?? null)) != "")>@lang('FREE')
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Price')</label>
                                    <input type="number" name="price" class="form-control" min="0"
                                        value="{{ old('price', getAmount($plan->price ?? null)) }}" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="d-flex justify-content-between mb-2">
                                        <label>@lang('Feature')</label>
                                        <button type="button" class="btn btn-sm btn-primary addMoreFeatureBtn">
                                            <i class="la la-plus"></i>
                                            @lang('Add More')
                                        </button>
                                    </div>
                                    <input type="text" name="features[]" class="form-control"
                                        value="{{ $plan->features[0] ?? null }}" required>
                                </div>
                                <div class="moreFeatures">
                                    @foreach ($plan->features ?? [] as $feature)
                                        @continue($loop->first)
                                        <div class="form-group d-flex justify-content-between">
                                            <input type="text" name="features[]" class="form-control"
                                                value="{{ $feature }}" required>
                                            <button type="button" class="btn btn-sm btn-danger removeFeatureBtn ms-2">
                                                <i class="las la-trash-alt ps-1"></i>
                                            </button>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="col-md-12">
                                <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.plans.index') }}" />
@endpush

@push('script')
    <script>
        "use strict";

        $('.addMoreFeatureBtn').on('click', function() {
            let html = `<div class="form-group d-flex justify-content-between">
                <input type="text" name="features[]" class="form-control" required>
                <button type="button" class="btn btn-sm btn-danger removeFeatureBtn ms-2">
                    <i class="las la-trash-alt ps-1"></i>
                </button>
            </div>`;
            $('.moreFeatures').append(html);
        });

        $(document).on('click', '.removeFeatureBtn', function() {
            $(this).closest('.form-group').remove();
        });
    </script>
@endpush
